/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IInventoryResponder;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EffectName
extends AbstractEffect {
    public static EffectName INSTANCE = new EffectName();

    private EffectName() {
        super("name", "Name");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        Component newName = null;
        if (spellContext.castingTile instanceof IInventoryResponder) {
            newName = ((IInventoryResponder)spellContext.castingTile).getItem(new ItemStack((ItemLike)Items.f_42656_)).m_41611_().m_6879_();
        } else if (shooter instanceof Player) {
            ItemStack stack;
            Player playerEntity = (Player)shooter;
            NonNullList list = playerEntity.f_36093_.f_35974_;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack2 = (ItemStack)list.get(i);
                if (stack2.m_41720_() != Items.f_42656_) continue;
                newName = stack2.m_41611_().m_6879_();
                break;
            }
            if (newName == null && spellContext.getCaster() != null && (stack = StackUtil.getHeldSpellbook((Player)spellContext.getCaster())) != ItemStack.f_41583_ && stack.m_41720_() instanceof SpellBook && stack.m_41783_() != null) {
                ISpellCaster caster = CasterUtil.getCaster(stack);
                newName = new TextComponent(caster.getSpellName());
            }
        }
        rayTraceResult.m_82443_().m_6593_(newName != null ? newName : TextComponent.f_131282_);
        if (rayTraceResult.m_82443_() instanceof Mob) {
            ((Mob)rayTraceResult.m_82443_()).m_21530_();
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return this.livingEntityHitSuccess(rayTraceResult);
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 25;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Names an entity after the set Spell Name. Can be overridden with a name tag in the hotbar.";
    }
}

